/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_strstatus.c,v 1.7 2005/06/29 00:23:16 eugene Exp $";

#include <stdio.h>
#include "mx_auto_config.h"
#include "myriexpress.h"

const char*
mx_strstatus(mx_status_code_t status)
{
  static char buf[80];

  switch(status){
  case MX_STATUS_SUCCESS:
      return "Successful completion";
  case MX_STATUS_PENDING:
      return "Request still pending";
  case MX_STATUS_BUFFERED:
      return "Request has been buffered, but still pending";
  case MX_STATUS_REJECTED:
      return "Posted operation failed";
  case MX_STATUS_TIMEOUT:
      return "Posted operation timed out";
  case MX_STATUS_TRUNCATED:
      return "Operation completed, but data was truncated due to undersized buffer";
  case MX_STATUS_CANCELLED:
      return "Panding receive was cancelled";
  case MX_STATUS_ENDPOINT_UNKNOWN:
      return "Destination endpoint is unknown on the network fabric";
  case MX_STATUS_ENDPOINT_CLOSED:
      return "remoted endpoint is closed";
  case MX_STATUS_ENDPOINT_UNREACHABLE:
      return "Connectivity is broken between the source and the destination";
  default:
    sprintf(buf, "Unknown status code: %d", status);
    return buf;
  }
}
